#!/bin/sh
#
# ZDaemon Server invokation script with auto-recovery,
# crash logging and an upper crash limit.
#
# Copyright (C) 2003, The ZDaemon Team
########################################################
WADDIR=/opt/zdaemon/wads
CRASHCOUNT=0
MAXCRASH=100
ulimit -c 0
while (true)
do
	./zserv -port 10601 -waddir $WADDIR -iwad doom2 -file brit11 </dev/null >/dev/null 2>&1 &
	PID=$!
	trap "kill -15 $PID; exit 0" 15
	wait
	echo  `date '+%Y-%m-%d %H:%M:%S'` : zserv crash >> zserv.crashlog
	CRASHCOUNT=`expr $CRASHCOUNT + 1`
	if [ $CRASHCOUNT -ge $MAXCRASH ]; then break; fi
	sleep 2
done
